-- Populism_blocks_courthouse.lua
-- Author: Machiavelli
-- DateCreated: 5/31/2012 3:58:03 PM
--------------------------------------------------------------
-------------
-- Purpose: -
-------------
-- This lua prevents people from building courthouses while they have the populism Social policy
-- because populism provide the court house effect for no maintenance.
--
function PopulismBlocksCourtHouse(playerID, iBuildingTypeID)
	local result = true;

	-- Is this the court house
	if(GameInfo.Buildings[iBuildingTypeID].BuildingClass == "BUILDINGCLASS_COURTHOUSE") then
		local player = Players[playerID];
		local policyID = GameInfoTypes["POLICY_POPULISM"];
	
		-- Does the player have populism
		if(player:HasPolicy(policyID) and not player:IsPolicyBlocked(policyID)) then
			result = false;
		end
	end

	return result;
end
GameEvents.PlayerCanConstruct.Add(PopulismBlocksCourtHouse);